<?php
header("Content-Type: application/json");

function respond($success, $message) {
  echo json_encode([
    "success" => $success,
    "message" => $message,
    "footer"  => "Developed and managed by OPSIS-SYSTEM IT Team. All rights reserved."
  ]);
  exit;
}

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  respond(false, "Invalid request method.");
}

$name    = htmlspecialchars(trim($_POST["name"] ?? ''));
$email   = htmlspecialchars(trim($_POST["email"] ?? ''));
$phone   = htmlspecialchars(trim($_POST["phone"] ?? ''));
$message = htmlspecialchars(trim($_POST["message"] ?? ''));

if (empty($name) || empty($email) || empty($phone) || empty($message)) {
  respond(false, "All fields are required.");
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  respond(false, "Invalid email address.");
}

$to      = "opg66068@gmail.com";
$subject = "📨 New Contact Form Submission from $name";

// HTML Email Template
$body = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
      color: #333;
    }
    .container {
      background-color: #ffffff;
      border-radius: 8px;
      padding: 30px;
      max-width: 600px;
      margin: auto;
      box-shadow: 0 10px 20px rgba(0,0,0,0.05);
    }
    h2 {
      color: #1A56DB;
      margin-bottom: 20px;
    }
    p {
      line-height: 1.6;
      margin: 5px 0;
    }
    .footer {
      margin-top: 30px;
      font-size: 13px;
      color: #888;
      border-top: 1px solid #eee;
      padding-top: 15px;
    }
    strong {
      color: #0F2A5E;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2>📨 New Contact Submission</h2>
    <p><strong>Name:</strong> {$name}</p>
    <p><strong>Email:</strong> {$email}</p>
    <p><strong>Phone:</strong> {$phone}</p>
    <p><strong>Message:</strong><br />{$message}</p>

    <div class="footer">
      🚀 Developed and managed by <strong>OPSIS-SYSTEM IT Team</strong><br />
      &copy; 2025 All rights reserved.
    </div>
  </div>
</body>
</html>
HTML;

$headers  = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type: text/html; charset=UTF-8" . "\r\n";
$headers .= "From: noreply@opsis-system.in\r\n";
$headers .= "Reply-To: {$email}\r\n";

if (mail($to, $subject, $body, $headers)) {
  respond(true, "✅ Message sent successfully!");
} else {
  respond(false, "❌ Failed to send message. Please try again later.");
}
?>
