<?php
header("Content-Type: application/json");

function respond($success, $message) {
  echo json_encode([
    "success" => $success,
    "message" => $message,
    "footer"  => "Developed and managed by OPSIS-SYSTEM IT Team. All rights reserved."
  ]);
  exit;
}

if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  respond(false, "Invalid request method.");
}

// Sanitize and validate inputs
$name     = htmlspecialchars(trim($_POST["name"] ?? ''));
$email    = htmlspecialchars(trim($_POST["email"] ?? ''));
$phone    = htmlspecialchars(trim($_POST["phone"] ?? ''));
$company  = htmlspecialchars(trim($_POST["company"] ?? ''));
$message  = htmlspecialchars(trim($_POST["message"] ?? ''));

if (!$name || !$email || !$phone || !$message) {
  respond(false, "All fields except Company are required.");
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
  respond(false, "Invalid email address.");
}

// Metadata
$submittedAt = date("d M Y, h:i A");
$ipAddress   = $_SERVER['REMOTE_ADDR'] ?? 'Unknown IP';
$leadSource  = "Smart Geospatial Suite";

// Email destination and subject
$to      = "opg66068@gmail.com";
$subject = "📌 New GIS Lead - {$name} ({$company})";

// Email body in HTML
$body = <<<HTML
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <style>
    body { font-family: 'Segoe UI', sans-serif; background-color: #f9f9f9; color: #333; padding: 20px; }
    .container { background-color: #fff; padding: 30px; border-radius: 8px; max-width: 600px; margin: auto; box-shadow: 0 4px 20px rgba(0,0,0,0.08); }
    h2 { color: #1A56DB; }
    .field { margin: 10px 0; }
    .field strong { display: inline-block; width: 140px; color: #0F2A5E; }
    .footer { margin-top: 30px; font-size: 12px; color: #777; border-top: 1px solid #eee; padding-top: 15px; }
    a { color: #1A56DB; text-decoration: none; }
  </style>
</head>
<body>
  <div class="container">
    <h2>📌 New GIS Product Enquiry</h2>
    <div class="field"><strong>Lead Source:</strong> {$leadSource}</div>
    <div class="field"><strong>Submitted On:</strong> {$submittedAt}</div>
    <div class="field"><strong>Name:</strong> {$name}</div>
    <div class="field"><strong>Email:</strong> <a href="mailto:{$email}">{$email}</a></div>
    <div class="field"><strong>Phone:</strong> <a href="tel:{$phone}">{$phone}</a></div>
    <div class="field"><strong>Company:</strong> {$company}</div>
    <div class="field"><strong>Requirement:</strong><br />{$message}</div>
    <div class="field"><strong>IP Address:</strong> {$ipAddress}</div>

    <div class="footer">
      🚀 Lead generated via <strong>Smart Geospatial Suite</strong> landing page.<br />
      Developed by OPSIS-SYSTEM IT Team • &copy; 2025 All rights reserved.
    </div>
  </div>
</body>
</html>
HTML;

// Email headers
$headers  = "MIME-Version: 1.0\r\n";
$headers .= "Content-type: text/html; charset=UTF-8\r\n";
$headers .= "From: GIS Lead <noreply@opsis-system.in>\r\n";
$headers .= "Reply-To: {$email}\r\n";

// Send the email
if (mail($to, $subject, $body, $headers)) {
  respond(true, "✅ Thank you! Your enquiry was sent successfully.");
} else {
  respond(false, "❌ Failed to send message. Please try again or contact us via phone.");
}
?>
